#!/usr/bin/env python3.8

from functools import wraps 
  # wraps est un décorateur qui permet de décorer la fonction wrapper 
  # du décorateur que l'on construit pour le rendre transparent. 
  # comme ça on peut utiliser en cascade une suite de décorateur, de 
  # l’extérieur, on ne vois que les informations de la fonction décoré.

def logging(func):
    """
    Un décorateur qui log l'activité d'un script.
    (Ok, en vrai ça fait un print, mais ça pourrait logger !)
    """
    @wraps(func)
    def wrapper(*args, **kwargs):
        print("Initialisation de '{} {} {}'".format(func.__name__, args, kwargs))
        res = func(*args, **kwargs)
        print("Fin de la fonction '{}'".format(func.__name__))
        return res
    return wrapper

def benchmark(func):                                                            
    """                                                                         
    Un décorateur qui affiche le temps qu'une fonction met à s'éxécuter         
    """                                                                         
    import time    
    @wraps(func)                                                             
    def wrapper(*args, **kwargs):                                               
        t = time.perf_counter()                                                 
        res = func(*args, **kwargs)                                             
        #log.debug("Durée de l’exécution de la fonction '{}' --> {:0.2e}s".format(func.__name__, time.perf_counter()-t))
        print("Durée de l’exécution de la fonction '{}' --> {:0.2e}s".format(func.__name__, time.perf_counter()-t))
        return res                                                              
    return wrapper 

def Fibonacci(n):

    # Check if input is 0 then it will
    # print incorrect input
    if n < 0:
        print("Incorrect input")

    # Check if n is 0
    # then it will return 0
    elif n == 0:
        return 0

    # Check if n is 1,2
    # it will return 1
    elif n == 1 or n == 2:
        return 1

    else:
        return Fibonacci(n-1) + Fibonacci(n-2)

@benchmark
@logging
def gFibo(NUMBER):
    Fibonacci(NUMBER)

gFibo(12)