 #!/usr/bin/bash

# sécurisation de l'éxécution (mode strict)
set -e # plante le batch sur une erreur lors de l'éxécution (pas besoin de traiter le return code pour ça)
set -u # plante le batch si on utilise une variable non défini
set -o pipefail # plante le batch si une commande dans un pipe plante

#IFS=$'\n\t' # gestion des espaces dans les lignes si besoin

##    
## Bloc des fonctions
##

function utilisation
{
    echo "Aide du programme"
    echo "mon_prog [OPTION] ..."
    echo "  -a, --append, append... [obligatoire]"
    echo "  -e, --exec, execute..."
    echo ""
}

function controle_parm
{
    if [[ -z "$a" ]] then
        echo "append non défini"
        utilisation
        return 1
    fi
}

##
## Chargement des valeurs par défaut
##

config_fic=~/mon_scriptrc.cfg
tmp_cfg=/tmp/mon_scriptrc.cfg.tmp
b="blabla"
c="machine"

##
## gestion d'un fichier de configuration
##

# si le fichier de config existe
if [[ -f $config_fic ]] then
    # suppression des lignes commençant par un #
    grep "^#" $config_fic > $tmp_cfg
    # traitement du fichier
    while read ligne
    do
        parm=$(echo $ligne | awk -F "=" '{print $1;}')
        val=$(echo $ligne | awk -F "=" '{print $2;}')
    # ici, on va placer les valeurs attendu du fichier de configuration
    # Le fichier de conf étant de la forme parm=val
    # parm)
    #    parm=$val;

        case $parm in
            append)
                a=$val;
            ;;

            *)
                echo "parametre $parm inconnue..."
                exit 1
            ;;
        esac
    done < $tmp_cfg
    # suppression du fichier temporaire
    rm $tmp_cfg
fi

##
## gestion de paramètre en entrée saisie par l'opérateur
##

while [[ $# -gt 0 ]]
do
    case $1 in
        -a|--append)
            shift;
            a=$1;
            shift;
        ;;

        -e|--exec)
            exec ;
            shift;
        ;;

        *)
            echo "parametre $1 inconnue";
            shift;
        ;;
    esac
done

##
## contrôle des paramètres obligatoires
##

controle_parm
if [[ $? -eq 1 ]] then
    exit 1
fi

##
## début du script
##

##
## fin du script
##

return $RC; # pensez au return code !!!
