#!/usr/bin/env python3
# -*- coding: utf-8 -*-

def app():
    import logging
    from logging.handlers import RotatingFileHandler
    import argparse

    # construction du logger
    LOGGER = logging.getLogger()
    LOGGER.setLevel(logging.ERROR)
    #LOGGER.setLevel(logging.DEBUG)
    formatter = logging.Formatter('%(asctime)s :: %(module)s :: %(levelname)s :: %(message)s')

    # écriture d'un fichier de log
    file_handler = RotatingFileHandler(__file__ + '.log', 'a', 1000000, 1)
    file_handler.setFormatter(formatter)
    LOGGER.addHandler(file_handler)

    # écriture de log sur la sortie standard
    stream_handler = logging.StreamHandler()
    stream_handler.setFormatter(formatter)
    LOGGER.addHandler(stream_handler)

    # gestion des arguments avec argparse, ici on reprend un version modifié mise en place pour agent_dpluzz
    # https://docs.python.org/fr/3.6/howto/argparse.html

    PARSER = argparse.ArgumentParser(
        description="présentation générale \
    de l'outil.")

    # FLAG
    PARSER.add_argument("-d",
                        "--download",
                        action="store_true",
                        help="description de la fonction.")

    # Passage de parametre
    PARSER.add_argument("-lpf",
                        "--pattern_load",
                        type=str,
                        metavar=('FICHIER'),
                        help="Charge un fichier de motif (les lignes vide et commençant pas un # sont filtré).")

    # Compteur
    PARSER.add_argument("-v",
                        "--verbosity",
                        action='count',
                        default=2,
                        help="défini le niveau de verbosité à afficher.")

    # Parsing des arguments
    ARGS = PARSER.parse_args()

    # controle du compteur
    if ARGS.verbosity >= 5:
        LOGGER.setLevel(logging.DEBUG)
        LOGGER.warning("Niveau de la log : DEBUG")
    if ARGS.verbosity == 4:
        LOGGER.setLevel(logging.INFO)
        LOGGER.warning("Niveau de la log : INFO")
    if ARGS.verbosity == 3:
        LOGGER.setLevel(logging.WARNING)
        LOGGER.warning("Niveau de la log : WARNING")
    if ARGS.verbosity == 2:
        LOGGER.setLevel(logging.ERROR)

    # controle du FLAG
    if ARGS.download:
        LOGGER.info("fonction download activé")

    # controle du passage de parametre
    if ARGS.pattern_load:
        LOGGER.info("motif : %s"%ARGS.pattern_load)


    #
    # Debut du programme
    #

    LOGGER.warning("Début du programme")

    pass

    LOGGER.warning("Fin du programme")

    #
    # Fin du programme
    #

    exit(0)



if __name__ == '__main__':

    try:
        app()
    except Exception as error:
        LOGGER.error(f"Erreur inatendu : {error}")
        sys.exit(1)
    finally:
        pass
