#!/usr/bin/python3
# -*- coding: utf-8 -*-

import logging
from logging.handlers import RotatingFileHandler
import argparse

# construction du logger
LOGGER = logging.getLogger()
LOGGER.setLevel(logging.WARNING)
#LOGGER.setLevel(logging.DEBUG)
formatter = logging.Formatter('%(asctime)s :: %(module)s :: %(levelname)s :: %(message)s')

# écriture d'un fichier de log
file_handler = RotatingFileHandler('activity.log', 'a', 1000000, 1)
file_handler.setFormatter(formatter)
LOGGER.addHandler(file_handler)

# écriture de log sur la sortie standard
stream_handler = logging.StreamHandler()
stream_handler.setFormatter(formatter)
LOGGER.addHandler(stream_handler)

# gestion des arguments avec argparse, ici on reprend un version modifié mise en place pour agent_dpluzz
# https://docs.python.org/fr/3.6/howto/argparse.html

PARSER = argparse.ArgumentParser(
    description="présentation générale \
de l'outil.")

# FLAG
PARSER.add_argument("-d",
                    "--download",
                    action="store_true",
                    help="description de la fonction.")

# Passage de parametre
PARSER.add_argument("-lpf",
                    "--pattern_load",
                    type=str,
                    metavar=('FICHIER'),
                    help="Charge un fichier de motif (les lignes vide et commençant pas un # sont filtré).")

# Compteur
PARSER.add_argument("-v",
                    "--verbosity",
                    action='count',
                    help="défini le niveau de verbosité à afficher.")

# Parsing des arguments
ARGS = PARSER.parse_args()

# controle du compteur
if ARGS.verbosity == 5:
    LOGGER.setLevel(logging.DEBUG)
if ARGS.verbosity == 4:
    LOGGER.setLevel(logging.INFO)
if ARGS.verbosity == 3:
    LOGGER.setLevel(logging.WARNING)
if ARGS.verbosity == 2:
    LOGGER.setLevel(logging.ERROR)
if ARGS.verbosity == 1:
    LOGGER.setLevel(logging.CRITICAL)

# controle du FLAG
if ARGS.download:
    pritnt("fonction download activé")
    exit(0)

# controle du passage de parametre
if ARGS.pattern_load:
    print("motif : %s"%ARGS.pattern_load)
    exit(0)
