#!/usr/bin/env python3.7

from npc_factory import npc_factory
from weapon_factory import weapon_factory

class abstract_factory():
    def get(object_type):
        try:
            if object_type in ['hacker', 'ganger']:
                return npc_factory.get_npc(object_type)
            if object_type in ['pistolet', 'mitraillette']:
                return weapon_factory.get_weapon(object_type)
            raise AssertionError(f"Le type '{object_type}' n'existe pas.")
        except AssertionError as _e:
            print(_e)
            exit(1)

if __name__ == '__main__':
    obj = abstract_factory.get('hacker')
    obj.affichage()
    obj = abstract_factory.get('pistolet')
    obj.affichage()
    obj = abstract_factory.get('hackerNPC')
    obj.affichage()