#!/usr/bin/env python3.7

class NPC ():
    def affichage(self):
        print(f"Nom : {self.nom}")

class gangerNPC(NPC):
    def __init__(self):
        self.nom = """Morales"""

class hackerNPC(NPC):
    def __init__(self):
        self.nom = """Templar"""

class npc_factory():
    def get_npc(npc_type):
        try:
            if npc_type == "hacker":
                return hackerNPC()
            if npc_type == "ganger":
                return gangerNPC()
            raise AssertionError(f"Le type '{npc_type}' est inconnue.") 
        except AssertionError as _e:
            print(_e)
            exit(1)

if __name__ == '__main__':
    npc = npc_factory.get_npc('hacker')
    npc.affichage()
    npc = npc_factory.get_npc('mage')
    npc.affichage()